/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.message;

import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.message.VWConsoleMsg;
import filenet.vw.apps.taskman.resources.VWResource;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class VWConsoleMsgTableModel
extends AbstractTableModel {
    private int m_maxMessages = 100;
    public static final int NUM_COLUMNS = 4;
    public static final int MSGTYPE_COL = 0;
    public static final int TIME_COL = 1;
    public static final int MESSAGE_COL = 2;
    public static final int SOURCE_COL = 3;
    private static final int PRUNE_AMOUNT = 50;
    private String[] m_columnNames = null;
    private Vector m_rowData = new Vector();
    protected static final Icon ERROR_ICON = filenet.vw.toolkit.design.message.images.VWImageLoader.createImageIcon("error.gif");
    protected static final Icon WARNING_ICON = filenet.vw.toolkit.design.message.images.VWImageLoader.createImageIcon("warning.gif");
    protected static final Icon INFO_ICON = VWImageLoader.createImageIcon("info.gif");

    public VWConsoleMsgTableModel() {
        this.m_rowData.ensureCapacity(this.m_maxMessages + 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessages(int maxMessages) {
        VWConsoleMsgTableModel vWConsoleMsgTableModel = this;
        synchronized (vWConsoleMsgTableModel) {
            if (maxMessages > this.m_maxMessages) {
                this.pruneMessages();
            }
            this.m_maxMessages = maxMessages;
            this.pruneMessages();
            this.m_rowData.ensureCapacity(this.m_maxMessages + 50);
            this.fireTableDataChanged();
        }
    }

    public int getMaxMessages() {
        return this.m_maxMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(VWConsoleMsg message) {
        VWConsoleMsgTableModel vWConsoleMsgTableModel = this;
        synchronized (vWConsoleMsgTableModel) {
            if (this.m_rowData.size() > this.m_maxMessages + 50) {
                this.pruneMessages();
            }
            this.m_rowData.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWConsoleMsg getMessageAt(int nRowIndex) {
        VWConsoleMsgTableModel vWConsoleMsgTableModel = this;
        synchronized (vWConsoleMsgTableModel) {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex >= this.m_rowData.size()) {
                return null;
            }
            return (VWConsoleMsg)this.m_rowData.get(this.m_rowData.size() - 1 - nRowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        VWConsoleMsgTableModel vWConsoleMsgTableModel = this;
        synchronized (vWConsoleMsgTableModel) {
            this.m_rowData.clear();
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        if (nColumnIndex < 0 || nColumnIndex >= 4) {
            return null;
        }
        switch (nColumnIndex) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return Date.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return VWConsoleMsg.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        if (nColumnIndex < 0 || nColumnIndex >= 4) {
            return null;
        }
        switch (nColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return VWResource.Time;
            }
            case 2: {
                return VWResource.Message;
            }
            case 3: {
                return VWResource.Source;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        VWConsoleMsgTableModel vWConsoleMsgTableModel = this;
        synchronized (vWConsoleMsgTableModel) {
            if (this.m_rowData.size() > this.m_maxMessages) {
                return this.m_maxMessages;
            }
            return this.m_rowData.size();
        }
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        if (nColumnIndex < 0 || nColumnIndex >= 4) {
            return null;
        }
        VWConsoleMsg message = this.getMessageAt(nRowIndex);
        if (message == null) {
            return null;
        }
        switch (nColumnIndex) {
            case 0: {
                return message.getTypeIcon();
            }
            case 1: {
                return message.getTime();
            }
            case 2: {
                return message.getMessage();
            }
            case 3: {
                return message;
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    private void pruneMessages() {
        int numberToDelete = 0;
        if (this.m_rowData.size() > this.m_maxMessages) {
            numberToDelete = this.m_rowData.size() - this.m_maxMessages;
        }
        for (int i = 0; i < numberToDelete; ++i) {
            this.m_rowData.remove(0);
        }
    }
}

